# --- generic mux absorbption

func clkendffopt {
        abstract connection cc
        abstract instance i i2
        abstract net inp n
        list gtdfflist Fblist
        list bdylist dfflist
        global int rplcnt
        global list idel tplsigs
#
        if( @Netlist._env.fpga_tech != MAX7000) (return)
        dfflist = '(DFF DFFRS DFFR DFFS)
        idel = '()
#
        gtdfflist = Fblist = '()
        rplcnt = 0
        foreach i (instances @Netlist) {
                if (!(isinlist @i._gatetype._gflname @dfflist)) (continue)
                # check correct configuration on dffrs
                if (! (chkdffrs @i)) (continue)
                append gtdfflist @i
        }
        if ((listlen @gtdfflist) == 0 ) (return 0)
        # "01010011" is the muxsig with (q d sel)/(in0 in1 sel) order
        tplsigs = (bldtplsigs "01010011" 3)
#println tplsigs @tplsigs
        copydesign 6
        foreach i @gtdfflist {
                cc = (findconn @i in)
                inp = @cc._net          # input net
                cc = (findconn @i out)    # feedback net
                Fblist = (bld @cc._net) # list of feedback net
                # get list of three-net group, with the fb net at first
                bdylist = (lo_seqsigbdy @inp 3 @Fblist)
#println bdylist @bdylist
                if ((listlen @bdylist) == 0) (continue)
                if (savegflmux @bdylist @inp @i) {
                        println "*** Error: Failed to replace clock-enable flip-flop at:" @i._name
                        goto bad_return
                }
        }
        if ((listlen @idel) != 0) {
                foreach i @idel {
                        deleteinstance @Netlist @i
                }
        }
        if (@rplcnt) {
                cleanup
                println "*** Convert" @rplcnt  \
                  "clock-enable flip-flop structures into technology flip-flops."
        }
        return 0
    bad_return:
        restoredesign 6
        return 1
}

func chkdffrs (abstract instance i) {
        abstract connection c
        switch @Netlist._env.fpga_tech {
            MAX7000 { return DFFE }
            ()      { return "" }

         }

 return ""
}

func savegflmux (list bdylist; abstract net inp; abstract instance i) {
        global list muxsig
        list l
        int inv
#
        foreach l @bdylist {
                lo_setinputboundry @l
                muxsig =  (lo_normalizesig 3 (netsig @inp._name))
#println muxsig @muxsig
                inv = (matchsig @muxsig @tplsigs)
#println inv @inv
                #
                # inv is signature entry and inversion index
                # we also skip the inversion of q
                #
                if (@inv < 0 )  (continue)
                muxdff2cedff @l @i @muxsig[1] @tplsigs[@inv][1] @inv
                return 0
      }
 }

func muxdff2cedff (list bdyl ; abstract instance i; list op tp; int inv) {
        abstract connection cin c
        abstract net dn seln sn rsn qn n clkn isn irsn
        int s_idx d_idx q_idx j
        string ffname 
        abstract instance false
#
        ffname = ""
        ffname = (chkdffrs @i)

        cin = (catch () findconn @i in)
        if (isnull @cin) (return 1)
        # get the set/reset net
        switch @i._gatetype._gflname {
                DFFR  {
                      c = (catch () findconn @i reset)
                      rsn = @c._net
                      }
                DFFS  {
                       c = (catch () findconn @i set)
                       sn = @c._net
                      } 
                DFFRS {
                        c = (catch () findconn @i set)
                        sn = @c._net
                        c = (catch () findconn @i reset)
                        rsn = @c._net
                }
                DFF {
                        rsn = (addnet @Netlist)
                        false = (addinstance @Netlist (assn '{
                                gatetype FALSE
                                conns (bld @rsn)
                        }))
                        sn = @rsn
                }
        }
        c = (catch () findconn @i clk)
        if (isnull @c) (return 1)
        clkn = @c._net
        qn = @bdyl[0]
        for (j = 0; @j < 3; j++) {
                switch @tp[@j] {
                        1 (d_idx = @j)
                        2 (s_idx = @j)
                }
        }
         # get the true index
        d_idx = @op[@d_idx]
        s_idx = @op[@s_idx]

        # handle the inversion
        if (@inv &1) {
#println "Ignore inversion on feedback"
                return 1
        }
        if (@inv & 2) {
                dn = (addnet @Netlist)
                addinstance @Netlist (assn '{
                        gatetype (cat @Techdef.prefix INV)
                        conns (bld @dn @bdyl[@d_idx])
                })
        } else {
                dn = @bdyl[@d_idx]
        }
        if (@inv & 4) {
                seln = (addnet @Netlist)
                addinstance @Netlist (assn '{
                        gatetype (cat @Techdef.prefix INV)
                        conns (bld @seln @bdyl[@s_idx])
                })
        } else {
                seln = @bdyl[@s_idx]
        }

        isn = (addnet @Netlist)
        irsn = (addnet @Netlist)
        addinstance @Netlist (assn '{
                        gatetype (cat @Techdef.prefix INV)
                        conns (bld @isn @sn)
                })
        addinstance @Netlist (assn '{
                        gatetype (cat @Techdef.prefix INV)
                        conns (bld @irsn @rsn)
                })
        # order Q CLK CLR D PRE ENA 
        addinstance @Netlist (assn '{
                gatetype @ffname
                conns (bld @qn @clkn @irsn @dn @isn @seln)
        })
        append idel @i
        ++ rplcnt
        return 0
}


func matchsig (list sig lsig) {
        int inv i
        list l
#
        for (inv = 0; @inv < (listlen @lsig); inv++) {
                l = @lsig[@inv]
                if (@sig[0] != @l[0]) (continue)
                for (i = 0; @i < (listlen @l[1]); i++) {
                        if (@l[1][@i] != 0) (continue)
                        if (@sig[1][@i] == 0) (return @inv)
                }
        }
        return -1
}
func bldtplsigs (string sigstr; int numin) {
        list lnsigs lisigs
        string sig
#
        lisigs = (gen_ifuncs @sigstr @numin)
        lnsigs = '()
        foreach sig @lisigs {
                append lnsigs (lo_normalizesig @numin @sig)
        }
        return @lnsigs
}
# generate functions with corresponding input inversion
func gen_ifuncs (string sigstr; int numin) {
        string isig
        int i ibit siglen imap
        list ifuncs
#
        ifuncs = '()
        # Invert the entry, get the output bit from original function,
        # then build the inverted function
        siglen = (1 << @numin)
        for (ibit = 0; @ibit < @siglen; ibit++) {
                isig = ""
                for (i = 0; @i < @siglen; i++) {
                        imap = (@i ^ @ibit)
                        isig = (cat @isig (substr @sigstr @imap 1))
                }
                append ifuncs @isig
        }
#println ifuncs @ifuncs
        return @ifuncs
}


#--- Technology MUX absorbption

func xlgtdffopt {
        abstract connection cc
        abstract instance i
        abstract net inp n
        list gtdfflist Fblist
        list bdylist
        list  gtdff 
        global int rplcnt
        global list tplsigs
        global list true
#
        gtdff = '(DFFE)
        true  = '(TRUE POWER)
        if( @Netlist._env.fpga_tech != MAX7000) (return)
        if (!(lo_hasnosourcecells_module)) (return)
        gtdfflist = Fblist = '()
        rplcnt = 0
        replace_DFF_with_DFFE @Netlist
        foreach i (instances @Netlist) {
                if (!(isinlist @i._gatetype._name @gtdff)) (continue)
                cc = (findconn @i ENA)
                n = @cc._net            # input
                if ( !(isinlist  @n._driver._instance._gatetype._name @true)) (continue)
                cc = (findconn @i D)
                n = @cc._net
                if (@n._numconns != 2) (continue)
                append gtdfflist @i
        }
        if ((listlen @gtdfflist) == 0 ) (return)
        # "01010011" is the muxsig with (q d sel)/(in0 in1 sel) order
        tplsigs = (bldtplsigs "01010011" 3)
#println tplsigs @tplsigs
        copydesign 6
        foreach i @gtdfflist {
                cc = (findconn @i D)
                inp = @cc._net          # input net
                cc = (findconn @i Q)    # feedback net
                Fblist = (bld @cc._net) # list of feedback net
                # get list of three-net group, with the fb net at first
                bdylist = (lo_seqsigbdy @inp 3 @Fblist)
                if ((listlen @bdylist) == 0) (continue)
#println bdylist @bdylist
                if (savemux @bdylist @inp @i) {
                       println "*** Error: Unable to replace clock-enable flip-flop at:" @i._name
                        goto bad_return
                }
        }
        if (@rplcnt) {
                makenetcomps
                optpass 1 1
                undonetcomps
                cleanup
                println "*** Convert" @rplcnt "clock-enable flip-flop structures into technology flip-flops."
                return 1
        }
        return 0
bad_return:
        restoredesign 6
        return 1
}

func savemux (list bdylist; abstract net inp; abstract instance i) {
        global list muxsig
        list l
        int inv
#
        foreach l @bdylist {
                lo_setinputboundry @l
                muxsig =  (lo_normalizesig 3 (netsig @inp._name))
#println muxsig @muxsig
                inv = (matchsig @muxsig @tplsigs)
#println inv @inv
                #
                # inv is signature entry and inversion index
                # we also skip the inversion of q
                #
                if (@inv < 0 )  (continue)
                muxff2cedff @l @i @muxsig[1] @tplsigs[@inv][1] @inv
                return 0
        }
        return 0
}

func muxff2cedff (list bdyl ; abstract instance i; list op tp; int inv) {
        abstract connection cce cin c
        abstract net dn seln
        int s_idx d_idx j
#
        cce = (catch () findconn @i ENA)
        if (isnull @cce) (return 1)
        cin = (catch () findconn @i D)
        if (isnull @cin) (return)
        for (j = 0; @j < 3; j++) {
                switch @tp[@j] {
                        1 (d_idx = @j)
                        2 (s_idx = @j)
                }
        }
        # get the true index
        d_idx = @op[@d_idx]
        s_idx = @op[@s_idx]

        # handle the inversion
        if (@inv &1) {
#println "Ignore inversion on feedback"
                return 1
        }
        if (@inv & 2) {
                dn = (addnet @Netlist)
                addinstance @Netlist (assn '{
                        gatetype (cat @Techdef.prefix INV)
                        conns (bld @dn @bdyl[@d_idx])
                })
        } else {
                dn = @bdyl[@d_idx]
        }
        if (@inv & 4) {
                seln = (addnet @Netlist)
                addinstance @Netlist (assn '{
                        gatetype (cat @Techdef.prefix INV)
                        conns (bld @seln @bdyl[@s_idx])
                })
        } else {
                seln = @bdyl[@s_idx]
        }
         # order Q C CE D RD/SD
        cin._net = @dn
        cce._net = @seln

        ++ rplcnt
}

func lo_hasnosourcecells_module (args nl) {
        abstract instance i
        abstract gatetype t
        abstract library lib

        if(isnull @nl) (nl = @Netlist)
        foreach i (instances @nl) {
                if ( @i._ismodule ) (continue)
                t = @i._gatetype
                lib = @t._view._cell._library
                if(@lib != @TargetLib && !(@lib == @GflLib && \
                        (instr @t._flags FCb))) (return 0)
        }
        return 1
}

func replace_DFF_with_DFFE (abstract netlist nl) {
abstract instance ii 
list iilist
list maplist siglist invlist str
abstract gatetype gg gginv
abstract net nn TRUEnet
abstract connection cc
   
    if( @Netlist._env.fpga_tech != MAX7000) (return) 
    maplist = '( (Q Q) ( QB QB) ( CLK CLK) ( CLR CLRN) (PRE PRN) (D D))
    iilist = '()
    gg = (findgatetype "ALTERA_LIB:DFFE")
    gginv = (findgatetype "ALTERA_LIB:INV")
    foreach ii ( instances @nl) {
          if ((@ii._gatetype._name == DFF) && \
              ( @ii._gatetype._view._cell._library != @GflLib)){
                  append iilist @ii 
          }
         if (@ii._gatetype._name == TRUE) {
                foreach cc (conns @ii) (TRUEnet = @cc._net)
         }
    }
    if ((listlen @iilist) == 0) (return)
     
    if (isnull @TRUEnet) {
       TRUEnet = (addnet @nl)
       addinstance @Netlist (assn '{
                             gatetype GFL_LIB:TRUE 
                             conns (bld @TRUEnet)
                            })
    }
    foreach ii @iilist {
           siglist = '()
           foreach str @maplist {
                switch @str[0] {
                    QB {
                          cc = (findconn @ii @str[0])
                          invlist = '()
                          if (@cc._net._numinputs > 0) {
                            append invlist (bld OUT @cc._net)
                            append invlist (bld IN @nn)
                            addinstance @nl @gginv._view @invlist
                         } 
                       }
                     Q {
                         cc = (findconn @ii @str[0])
                         append siglist (bld @str[1] @cc._net)
                         nn = @cc._net 

                       }
                    () {
                         cc = (findconn @ii @str[0])
                         append siglist (bld @str[1] @cc._net)
                       }
               } 
                
           }
           append siglist  (bld ENA @TRUEnet)
           addinstance @nl @gg._view @siglist
           deleteinstance @nl @ii
    }
}


